# coding: UTF-8

import pyvisa

BUFSIZE = 4096

class Myvisa:
    msg_buf = ""

	# コンストラクタ
    def __init__(self):
        self.rm = pyvisa.ResourceManager()

    # ライブラリ情報の取得
    def get_lib(self):
        return self.rm


    # リソース一覧の取得
    def get_resources(self):
        return self.rm.list_resources()


    # ポートオープン
    def open(self, resource):
        ret = False

        try:
            self.inst = self.rm.open_resource(resource)
            self.inst.write_termination = '\r\n'    # 送信ターミネーターの設定 (CR+LF)
            self.inst.read_termination = '\n'       # 受信ターミネーターの設定 (LF)
            self.rm.visalib.set_buffer(self.inst.session, pyvisa.constants.VI_READ_BUF, BUFSIZE)    # 受信バッファーサイズの設定

            ret = True
        except Exception as e:
            print("Open error")
            print(e)
        
        return ret


    # ポートのクローズ
    def close(self):
        ret = False

        try:
            self.rm.close()
            ret = True
        except Exception as e:
            print("Close error")
            print(e)
        
        return ret


    # コマンドの送信
    def send_msg(self, str_msg):
        ret = False

        try:
            self.inst.write(str_msg)                # 送信
            ret = True
        except Exception as e:
            print("Write error")
            print(e)

        return ret
    
    
    # コマンドの送受信
    def send_query_msg(self, str_msg, timeout_ms):
        ret = False

        try:
            if "?" in str_msg :
                Myvisa.msg_buf = ""                         # 受信バッファをクリア
                self.inst.timeout = timeout_ms              # タイムアウト設定
                Myvisa.msg_buf = self.inst.query(str_msg)   # 送受信
                Myvisa.msg_buf = Myvisa.msg_buf.replace('\r', '')
            else :
                self.send_msg(str_msg)                      # 送信のみ
            
            ret = True

        except Exception as e:
            print("Query error")
            print(e)
            Myvisa.msg_buf = "Error"

        return ret